/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends SystemFunction
implements XSLTFunction {
    String expressionBaseURI = null;
    public static final int UNPARSED_TEXT = 0;
    public static final int UNPARSED_TEXT_AVAILABLE = 1;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue result;
        try {
            StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
            if (hrefVal == null) {
                return null;
            }
            String href = hrefVal.getStringValue();
            String encoding = null;
            if (this.getNumberOfArguments() == 2) {
                encoding = this.argument[1].evaluateItem(context).getStringValue();
            }
            result = new StringValue(this.readFile(href, this.expressionBaseURI, encoding, context));
        }
        catch (XPathException err) {
            if (this.operation == 1) {
                return BooleanValue.FALSE;
            }
            throw err;
        }
        if (this.operation == 1) {
            return BooleanValue.TRUE;
        }
        return result;
    }

    private CharSequence readFile(String href, String baseURI, String encoding, XPathContext context) throws XPathException {
        URI absoluteURI;
        Configuration config = context.getConfiguration();
        NameChecker checker = config.getNameChecker();
        Platform platform = Configuration.getPlatform();
        try {
            absoluteURI = platform.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err) {
            XPathException e = new XPathException("Cannot resolve relative URI", err);
            e.setErrorCode("XTDE1170");
            throw e;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode("XTDE1170");
            throw e;
        }
        EscapeURI.checkPercentEncoding(absoluteURI.toString());
        Reader reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        try {
            int actual;
            FastStringBuffer sb = new FastStringBuffer(2048);
            char[] buffer = new char[2048];
            boolean first = true;
            int line = 1;
            int column = 1;
            while ((actual = reader.read(buffer, 0, 2048)) >= 0) {
                int c = 0;
                while (c < actual) {
                    int ch32;
                    if ((ch32 = buffer[c++]) == 10) {
                        ++line;
                        column = 0;
                    }
                    ++column;
                    if (UTF16.isHighSurrogate(ch32)) {
                        if (c == actual) {
                            actual = reader.read(buffer, 0, 2048);
                            c = 0;
                        }
                        char low = buffer[c++];
                        ch32 = UTF16.combinePair((char)ch32, low);
                    }
                    if (checker.isValidChar(ch32)) continue;
                    XPathException err = new XPathException("The unparsed-text file contains a character illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                    err.setErrorCode("XTDE1190");
                    throw err;
                }
                if (first) {
                    first = false;
                    if (buffer[0] == '\ufeff') {
                        sb.append(buffer, 1, actual - 1);
                        continue;
                    }
                    sb.append(buffer, 0, actual);
                    continue;
                }
                sb.append(buffer, 0, actual);
            }
            reader.close();
            return sb.condense();
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode("XTDE1190");
            throw e;
        }
        catch (IOException ioErr) {
            String message = "Failed to read input file";
            if (!ioErr.getMessage().equals(absoluteURI.toString())) {
                message = message + ' ' + absoluteURI.toString();
            }
            message = message + " (" + ioErr.getClass().getName() + ')';
            XPathException e = new XPathException(message, ioErr);
            String errorCode = ioErr instanceof MalformedInputException ? "XTDE1200" : (ioErr instanceof CharacterCodingException ? "XTDE1200" : (ioErr instanceof UnmappableCharacterException ? "XTDE1190" : "XTDE1170"));
            e.setErrorCode(errorCode);
            e.setLocator(this);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        FastStringBuffer sb1 = new FastStringBuffer(100);
        FastStringBuffer sb2 = new FastStringBuffer(100);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1.toString());
            System.out.println(sb2.toString());
            sb1 = new FastStringBuffer(100);
            sb2 = new FastStringBuffer(100);
        }
        System.out.println(sb1.toString());
        System.out.println(sb2.toString());
    }
}

