/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:
 * Abstract:
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __SEARCH_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __SEARCH_H__
#define __SEARCH_H__

#include "yforth.h"
#include "macro.h"


/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(definitions,					"definitions",			0)
code(forth_wordlist,				"forth-wordlist",		0)
code(get_current,					"get-current",			0)
code(get_order,						"get-order",			0)
code(search_wordlist,				"search-wordlist",		0)
code(set_current,					"set-current",			0)
code(set_order,						"set-order",			0)
code(wordlist,						"wordlist",				0)

#ifdef PROTOTYPES

/**************************************************************************/
/* AUXILIARY FUNCSIONS PROTOTYPES *****************************************/
/**************************************************************************/

void save_vocabulary(struct voc_marker *vm);
void load_vocabulary(struct voc_marker *vm);

#endif

#endif
