﻿/*
 * Copyright (C) 2013 ~ 2015 National University of Defense Technology(NUDT) & Kylin Ltd.
 *
 * Authors:
 *  Kobe Lee    xiangli@ubuntukylin.com/kobe24_lixiang@126.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TITLEWIDGET_H
#define TITLEWIDGET_H

#include <QWidget>
#include <QLabel>
#include <QPushButton>
#include <QMouseEvent>
#include <QHBoxLayout>
#include <QSignalMapper>
#include <QVBoxLayout>
#include "../component/kylinbutton.h"
#include "../component/systembutton.h"

class MainWindow;

class TitleWidget : public QWidget
{
    Q_OBJECT
public:
    explicit TitleWidget(QWidget *parent = 0, QString arch = "", QString os = "");
    ~TitleWidget();
    void setParentWindow(MainWindow* window) { p_mainwindow = window;}
    void initConnect();

//protected:
//    virtual void paintEvent(QPaintEvent *event);

signals:
    void closeApp();

private:
    QPoint press_point;//鼠标按下去的点
    bool is_move;
    SystemButton *min_button;
    SystemButton *close_button;
    SystemButton *skin_button;
    SystemButton *main_menu_button;

    MainWindow *p_mainwindow;
};

#endif // TITLEWIDGET_H
