/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

enum enum_action { action__NULL = -1, action_arg_benchmark = 0, action_arg_blinkMINUS_device, action_arg_createMINUS_otpMINUS_aead, action_arg_decryptMINUS_aesccm, action_arg_decryptMINUS_aescbc, action_arg_decryptMINUS_aesecb, action_arg_decryptMINUS_oaep, action_arg_decryptMINUS_otp, action_arg_decryptMINUS_pkcs1v15, action_arg_deleteMINUS_object, action_arg_deriveMINUS_ecdh, action_arg_encryptMINUS_aesccm, action_arg_encryptMINUS_aescbc, action_arg_encryptMINUS_aesecb, action_arg_generateMINUS_asymmetricMINUS_key, action_arg_generateMINUS_hmacMINUS_key, action_arg_generateMINUS_otpMINUS_aeadMINUS_key, action_arg_generateMINUS_wrapMINUS_key, action_arg_generateMINUS_symmetricMINUS_key, action_arg_getMINUS_deviceMINUS_info, action_arg_getMINUS_logs, action_arg_getMINUS_objectMINUS_info, action_arg_getMINUS_opaque, action_arg_getMINUS_option, action_arg_getMINUS_pseudoMINUS_random, action_arg_getMINUS_publicMINUS_key, action_arg_getMINUS_storageMINUS_info, action_arg_getMINUS_template, action_arg_getMINUS_wrapped, action_arg_getMINUS_deviceMINUS_pubkey, action_arg_listMINUS_objects, action_arg_putMINUS_asymmetricMINUS_key, action_arg_putMINUS_authenticationMINUS_key, action_arg_putMINUS_hmacMINUS_key, action_arg_putMINUS_opaque, action_arg_putMINUS_option, action_arg_putMINUS_otpMINUS_aeadMINUS_key, action_arg_putMINUS_symmetricMINUS_key, action_arg_putMINUS_template, action_arg_putMINUS_wrapMINUS_key, action_arg_putMINUS_wrapped, action_arg_randomizeMINUS_otpMINUS_aead, action_arg_reset, action_arg_setMINUS_logMINUS_index, action_arg_signMINUS_attestationMINUS_certificate, action_arg_signMINUS_ecdsa, action_arg_signMINUS_eddsa, action_arg_signMINUS_hmac, action_arg_signMINUS_pkcs1v15, action_arg_signMINUS_pss, action_arg_signMINUS_sshMINUS_certificate };
enum enum_informat { informat__NULL = -1, informat_arg_default = 0, informat_arg_base64, informat_arg_binary, informat_arg_PEM, informat_arg_password, informat_arg_hex, informat_arg_ASCII };
enum enum_outformat { outformat__NULL = -1, outformat_arg_default = 0, outformat_arg_base64, outformat_arg_binary, outformat_arg_PEM, outformat_arg_hex, outformat_arg_ASCII };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  enum enum_action *action_arg;	/**< @brief Action to perform.  */
  char ** action_orig;	/**< @brief Action to perform original value given at command line.  */
  unsigned int action_min; /**< @brief Action to perform's minimum occurreces */
  unsigned int action_max; /**< @brief Action to perform's maximum occurreces */
  const char *action_help; /**< @brief Action to perform help description.  */
  char * password_arg;	/**< @brief Authentication password.  */
  char * password_orig;	/**< @brief Authentication password original value given at command line.  */
  const char *password_help; /**< @brief Authentication password help description.  */
  int authkey_arg;	/**< @brief Authentication key (default='1').  */
  char * authkey_orig;	/**< @brief Authentication key original value given at command line.  */
  const char *authkey_help; /**< @brief Authentication key help description.  */
  short object_id_arg;	/**< @brief Object ID (default='0').  */
  char * object_id_orig;	/**< @brief Object ID original value given at command line.  */
  const char *object_id_help; /**< @brief Object ID help description.  */
  char * label_arg;	/**< @brief Object label (default='').  */
  char * label_orig;	/**< @brief Object label original value given at command line.  */
  const char *label_help; /**< @brief Object label help description.  */
  char * domains_arg;	/**< @brief Object domains (default='1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16').  */
  char * domains_orig;	/**< @brief Object domains original value given at command line.  */
  const char *domains_help; /**< @brief Object domains help description.  */
  char * capabilities_arg;	/**< @brief Capabilities for an object (default='0').  */
  char * capabilities_orig;	/**< @brief Capabilities for an object original value given at command line.  */
  const char *capabilities_help; /**< @brief Capabilities for an object help description.  */
  char * object_type_arg;	/**< @brief Object type (default='any').  */
  char * object_type_orig;	/**< @brief Object type original value given at command line.  */
  const char *object_type_help; /**< @brief Object type help description.  */
  char * ykhsmauth_label_arg;	/**< @brief Credential label on YubiKey (implicitly enables ykhsmauth).  */
  char * ykhsmauth_label_orig;	/**< @brief Credential label on YubiKey (implicitly enables ykhsmauth) original value given at command line.  */
  const char *ykhsmauth_label_help; /**< @brief Credential label on YubiKey (implicitly enables ykhsmauth) help description.  */
  char * ykhsmauth_reader_arg;	/**< @brief Only use a matching YubiKey reader name (default='').  */
  char * ykhsmauth_reader_orig;	/**< @brief Only use a matching YubiKey reader name original value given at command line.  */
  const char *ykhsmauth_reader_help; /**< @brief Only use a matching YubiKey reader name help description.  */
  char * delegated_arg;	/**< @brief Delegated capabilities (default='0').  */
  char * delegated_orig;	/**< @brief Delegated capabilities original value given at command line.  */
  const char *delegated_help; /**< @brief Delegated capabilities help description.  */
  char * new_password_arg;	/**< @brief New authentication password.  */
  char * new_password_orig;	/**< @brief New authentication password original value given at command line.  */
  const char *new_password_help; /**< @brief New authentication password help description.  */
  char * algorithm_arg;	/**< @brief Operation algorithm (default='any').  */
  char * algorithm_orig;	/**< @brief Operation algorithm original value given at command line.  */
  const char *algorithm_help; /**< @brief Operation algorithm help description.  */
  int nonce_arg;	/**< @brief OTP nonce.  */
  char * nonce_orig;	/**< @brief OTP nonce original value given at command line.  */
  const char *nonce_help; /**< @brief OTP nonce help description.  */
  char * iv_arg;	/**< @brief An initialization vector as a hexadecimal string.  */
  char * iv_orig;	/**< @brief An initialization vector as a hexadecimal string original value given at command line.  */
  const char *iv_help; /**< @brief An initialization vector as a hexadecimal string help description.  */
  int count_arg;	/**< @brief Number of bytes to request (default='256').  */
  char * count_orig;	/**< @brief Number of bytes to request original value given at command line.  */
  const char *count_help; /**< @brief Number of bytes to request help description.  */
  int duration_arg;	/**< @brief Blink duration in seconds (default='10').  */
  char * duration_orig;	/**< @brief Blink duration in seconds original value given at command line.  */
  const char *duration_help; /**< @brief Blink duration in seconds help description.  */
  int wrap_id_arg;	/**< @brief Wrap key ID.  */
  char * wrap_id_orig;	/**< @brief Wrap key ID original value given at command line.  */
  const char *wrap_id_help; /**< @brief Wrap key ID help description.  */
  int template_id_arg;	/**< @brief Template ID.  */
  char * template_id_orig;	/**< @brief Template ID original value given at command line.  */
  const char *template_id_help; /**< @brief Template ID help description.  */
  int attestation_id_arg;	/**< @brief Attestation ID.  */
  char * attestation_id_orig;	/**< @brief Attestation ID original value given at command line.  */
  const char *attestation_id_help; /**< @brief Attestation ID help description.  */
  int log_index_arg;	/**< @brief Log index.  */
  char * log_index_orig;	/**< @brief Log index original value given at command line.  */
  const char *log_index_help; /**< @brief Log index help description.  */
  char * opt_name_arg;	/**< @brief Device option name.  */
  char * opt_name_orig;	/**< @brief Device option name original value given at command line.  */
  const char *opt_name_help; /**< @brief Device option name help description.  */
  char * opt_value_arg;	/**< @brief Device option value.  */
  char * opt_value_orig;	/**< @brief Device option value original value given at command line.  */
  const char *opt_value_help; /**< @brief Device option value help description.  */
  char * in_arg;	/**< @brief Input data (filename) (default='-').  */
  char * in_orig;	/**< @brief Input data (filename) original value given at command line.  */
  const char *in_help; /**< @brief Input data (filename) help description.  */
  char * out_arg;	/**< @brief Output data (filename) (default='-').  */
  char * out_orig;	/**< @brief Output data (filename) original value given at command line.  */
  const char *out_help; /**< @brief Output data (filename) help description.  */
  enum enum_informat informat_arg;	/**< @brief Input format (default='default').  */
  char * informat_orig;	/**< @brief Input format original value given at command line.  */
  const char *informat_help; /**< @brief Input format help description.  */
  enum enum_outformat outformat_arg;	/**< @brief Input and output format (default='default').  */
  char * outformat_orig;	/**< @brief Input and output format original value given at command line.  */
  const char *outformat_help; /**< @brief Input and output format help description.  */
  char * config_file_arg;	/**< @brief Configuration file to read (default='').  */
  char * config_file_orig;	/**< @brief Configuration file to read original value given at command line.  */
  const char *config_file_help; /**< @brief Configuration file to read help description.  */
  char ** connector_arg;	/**< @brief List of connectors to use.  */
  char ** connector_orig;	/**< @brief List of connectors to use original value given at command line.  */
  unsigned int connector_min; /**< @brief List of connectors to use's minimum occurreces */
  unsigned int connector_max; /**< @brief List of connectors to use's maximum occurreces */
  const char *connector_help; /**< @brief List of connectors to use help description.  */
  char * cacert_arg;	/**< @brief HTTPS cacert for connector.  */
  char * cacert_orig;	/**< @brief HTTPS cacert for connector original value given at command line.  */
  const char *cacert_help; /**< @brief HTTPS cacert for connector help description.  */
  char * cert_arg;	/**< @brief HTTPS client certificate to authenticate with.  */
  char * cert_orig;	/**< @brief HTTPS client certificate to authenticate with original value given at command line.  */
  const char *cert_help; /**< @brief HTTPS client certificate to authenticate with help description.  */
  char * key_arg;	/**< @brief HTTPS client certificate key.  */
  char * key_orig;	/**< @brief HTTPS client certificate key original value given at command line.  */
  const char *key_help; /**< @brief HTTPS client certificate key help description.  */
  char * proxy_arg;	/**< @brief Proxy server to use for connector.  */
  char * proxy_orig;	/**< @brief Proxy server to use for connector original value given at command line.  */
  const char *proxy_help; /**< @brief Proxy server to use for connector help description.  */
  char * noproxy_arg;	/**< @brief Comma separated list of hosts ignore proxy for.  */
  char * noproxy_orig;	/**< @brief Comma separated list of hosts ignore proxy for original value given at command line.  */
  const char *noproxy_help; /**< @brief Comma separated list of hosts ignore proxy for help description.  */
  int verbose_arg;	/**< @brief Print more information (default='0').  */
  char * verbose_orig;	/**< @brief Print more information original value given at command line.  */
  const char *verbose_help; /**< @brief Print more information help description.  */
  int pre_connect_flag;	/**< @brief Connect immediately in interactive mode (default=off).  */
  const char *pre_connect_help; /**< @brief Connect immediately in interactive mode help description.  */
  char ** device_pubkey_arg;	/**< @brief List of device public keys allowed for asymmetric authentication.  */
  char ** device_pubkey_orig;	/**< @brief List of device public keys allowed for asymmetric authentication original value given at command line.  */
  unsigned int device_pubkey_min; /**< @brief List of device public keys allowed for asymmetric authentication's minimum occurreces */
  unsigned int device_pubkey_max; /**< @brief List of device public keys allowed for asymmetric authentication's maximum occurreces */
  const char *device_pubkey_help; /**< @brief List of device public keys allowed for asymmetric authentication help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int action_given ;	/**< @brief Whether action was given.  */
  unsigned int password_given ;	/**< @brief Whether password was given.  */
  unsigned int authkey_given ;	/**< @brief Whether authkey was given.  */
  unsigned int object_id_given ;	/**< @brief Whether object-id was given.  */
  unsigned int label_given ;	/**< @brief Whether label was given.  */
  unsigned int domains_given ;	/**< @brief Whether domains was given.  */
  unsigned int capabilities_given ;	/**< @brief Whether capabilities was given.  */
  unsigned int object_type_given ;	/**< @brief Whether object-type was given.  */
  unsigned int ykhsmauth_label_given ;	/**< @brief Whether ykhsmauth-label was given.  */
  unsigned int ykhsmauth_reader_given ;	/**< @brief Whether ykhsmauth-reader was given.  */
  unsigned int delegated_given ;	/**< @brief Whether delegated was given.  */
  unsigned int new_password_given ;	/**< @brief Whether new-password was given.  */
  unsigned int algorithm_given ;	/**< @brief Whether algorithm was given.  */
  unsigned int nonce_given ;	/**< @brief Whether nonce was given.  */
  unsigned int iv_given ;	/**< @brief Whether iv was given.  */
  unsigned int count_given ;	/**< @brief Whether count was given.  */
  unsigned int duration_given ;	/**< @brief Whether duration was given.  */
  unsigned int wrap_id_given ;	/**< @brief Whether wrap-id was given.  */
  unsigned int template_id_given ;	/**< @brief Whether template-id was given.  */
  unsigned int attestation_id_given ;	/**< @brief Whether attestation-id was given.  */
  unsigned int log_index_given ;	/**< @brief Whether log-index was given.  */
  unsigned int opt_name_given ;	/**< @brief Whether opt-name was given.  */
  unsigned int opt_value_given ;	/**< @brief Whether opt-value was given.  */
  unsigned int in_given ;	/**< @brief Whether in was given.  */
  unsigned int out_given ;	/**< @brief Whether out was given.  */
  unsigned int informat_given ;	/**< @brief Whether informat was given.  */
  unsigned int outformat_given ;	/**< @brief Whether outformat was given.  */
  unsigned int config_file_given ;	/**< @brief Whether config-file was given.  */
  unsigned int connector_given ;	/**< @brief Whether connector was given.  */
  unsigned int cacert_given ;	/**< @brief Whether cacert was given.  */
  unsigned int cert_given ;	/**< @brief Whether cert was given.  */
  unsigned int key_given ;	/**< @brief Whether key was given.  */
  unsigned int proxy_given ;	/**< @brief Whether proxy was given.  */
  unsigned int noproxy_given ;	/**< @brief Whether noproxy was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int pre_connect_given ;	/**< @brief Whether pre-connect was given.  */
  unsigned int device_pubkey_given ;	/**< @brief Whether device-pubkey was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_action_values[];  /**< @brief Possible values for action. */
extern const char *cmdline_parser_informat_values[];  /**< @brief Possible values for informat. */
extern const char *cmdline_parser_outformat_values[];  /**< @brief Possible values for outformat. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
