/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.inject.ProvidedBy;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.internal.util.Archaius1Utils;
import com.netflix.discovery.providers.DefaultEurekaClientConfigProvider;
import com.netflix.discovery.shared.transport.DefaultEurekaTransportConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@ProvidedBy(value=DefaultEurekaClientConfigProvider.class)
public class DefaultEurekaClientConfig
implements EurekaClientConfig {
    @Deprecated
    public static final String DEFAULT_NAMESPACE = "eureka.";
    public static final String DEFAULT_ZONE = "defaultZone";
    public static final String URL_SEPARATOR = "\\s*,\\s*";
    private final String namespace;
    private final DynamicPropertyFactory configInstance;
    private final EurekaTransportConfig transportConfig;

    public DefaultEurekaClientConfig() {
        this("eureka");
    }

    public DefaultEurekaClientConfig(String namespace) {
        this.namespace = namespace.endsWith(".") ? namespace : namespace + ".";
        this.configInstance = Archaius1Utils.initConfig("eureka-client");
        this.transportConfig = new DefaultEurekaTransportConfig(namespace, this.configInstance);
    }

    @Override
    public int getRegistryFetchIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "client.refresh.interval", 30).get();
    }

    @Override
    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "appinfo.replicate.interval", 30).get();
    }

    @Override
    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "appinfo.initial.replicate.time", 40).get();
    }

    @Override
    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "serviceUrlPollIntervalMs", 300000).get() / 1000;
    }

    @Override
    public String getProxyHost() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyHost", null).get();
    }

    @Override
    public String getProxyPort() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPort", null).get();
    }

    @Override
    public String getProxyUserName() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyUserName", null).get();
    }

    @Override
    public String getProxyPassword() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPassword", null).get();
    }

    @Override
    public boolean shouldGZipContent() {
        return this.configInstance.getBooleanProperty(this.namespace + "eurekaServer.gzipContent", true).get();
    }

    @Override
    public int getEurekaServerReadTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.readTimeout", 8).get();
    }

    @Override
    public int getEurekaServerConnectTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.connectTimeout", 5).get();
    }

    @Override
    public String getBackupRegistryImpl() {
        return this.configInstance.getStringProperty(this.namespace + "backupregistry", null).get();
    }

    @Override
    public int getEurekaServerTotalConnections() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.maxTotalConnections", 200).get();
    }

    @Override
    public int getEurekaServerTotalConnectionsPerHost() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.maxConnectionsPerHost", 50).get();
    }

    @Override
    public String getEurekaServerURLContext() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.context", this.configInstance.getStringProperty(this.namespace + "context", null).get()).get();
    }

    @Override
    public String getEurekaServerPort() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.port", this.configInstance.getStringProperty(this.namespace + "port", null).get()).get();
    }

    @Override
    public String getEurekaServerDNSName() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.domainName", this.configInstance.getStringProperty(this.namespace + "domainName", null).get()).get();
    }

    @Override
    public boolean shouldUseDnsForFetchingServiceUrls() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldUseDns", false).get();
    }

    @Override
    public boolean shouldRegisterWithEureka() {
        return this.configInstance.getBooleanProperty(this.namespace + "registration.enabled", true).get();
    }

    @Override
    public boolean shouldUnregisterOnShutdown() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldUnregisterOnShutdown", true).get();
    }

    @Override
    public boolean shouldPreferSameZoneEureka() {
        return this.configInstance.getBooleanProperty(this.namespace + "preferSameZone", true).get();
    }

    @Override
    public boolean allowRedirects() {
        return this.configInstance.getBooleanProperty(this.namespace + "allowRedirects", false).get();
    }

    @Override
    public boolean shouldLogDeltaDiff() {
        return this.configInstance.getBooleanProperty(this.namespace + "printDeltaFullDiff", false).get();
    }

    @Override
    public boolean shouldDisableDelta() {
        return this.configInstance.getBooleanProperty(this.namespace + "disableDelta", false).get();
    }

    @Override
    @Nullable
    public String fetchRegistryForRemoteRegions() {
        return this.configInstance.getStringProperty(this.namespace + "fetchRemoteRegionsRegistry", null).get();
    }

    @Override
    public String getRegion() {
        DynamicStringProperty defaultEurekaRegion = this.configInstance.getStringProperty("eureka.region", "us-east-1");
        return this.configInstance.getStringProperty(this.namespace + "region", defaultEurekaRegion.get()).get();
    }

    @Override
    public String[] getAvailabilityZones(String region) {
        return this.configInstance.getStringProperty(this.namespace + region + "." + "availabilityZones", DEFAULT_ZONE).get().split(URL_SEPARATOR);
    }

    @Override
    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = this.configInstance.getStringProperty(this.namespace + "serviceUrl" + "." + myZone, null).get();
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = this.configInstance.getStringProperty(this.namespace + "serviceUrl" + ".default", null).get();
        }
        if (serviceUrls != null) {
            return Arrays.asList(serviceUrls.split(URL_SEPARATOR));
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean shouldFilterOnlyUpInstances() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldFilterOnlyUpInstances", true).get();
    }

    @Override
    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaserver.connectionIdleTimeoutInSeconds", 45).get();
    }

    @Override
    public boolean shouldFetchRegistry() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldFetchRegistry", true).get();
    }

    @Override
    public boolean shouldEnforceFetchRegistryAtInit() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldEnforceFetchRegistryAtInit", false).get();
    }

    @Override
    public String getRegistryRefreshSingleVipAddress() {
        return this.configInstance.getStringProperty(this.namespace + "registryRefreshSingleVipAddress", null).get();
    }

    @Override
    public int getHeartbeatExecutorThreadPoolSize() {
        return this.configInstance.getIntProperty(this.namespace + "client.heartbeat.threadPoolSize", 5).get();
    }

    @Override
    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.configInstance.getIntProperty(this.namespace + "client.heartbeat.exponentialBackOffBound", 10).get();
    }

    @Override
    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.configInstance.getIntProperty(this.namespace + "client.cacheRefresh.threadPoolSize", 5).get();
    }

    @Override
    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.configInstance.getIntProperty(this.namespace + "client.cacheRefresh.exponentialBackOffBound", 10).get();
    }

    @Override
    public String getDollarReplacement() {
        return this.configInstance.getStringProperty(this.namespace + "dollarReplacement", "_-").get();
    }

    @Override
    public String getEscapeCharReplacement() {
        return this.configInstance.getStringProperty(this.namespace + "escapeCharReplacement", "__").get();
    }

    @Override
    public boolean shouldOnDemandUpdateStatusChange() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldOnDemandUpdateStatusChange", true).get();
    }

    @Override
    public boolean shouldEnforceRegistrationAtInit() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldEnforceRegistrationAtInit", false).get();
    }

    @Override
    public String getEncoderName() {
        return this.configInstance.getStringProperty(this.namespace + "encoderName", null).get();
    }

    @Override
    public String getDecoderName() {
        return this.configInstance.getStringProperty(this.namespace + "decoderName", null).get();
    }

    @Override
    public String getClientDataAccept() {
        return this.configInstance.getStringProperty(this.namespace + "clientDataAccept", EurekaAccept.full.name()).get();
    }

    @Override
    public String getExperimental(String name) {
        return this.configInstance.getStringProperty(this.namespace + "experimental" + "." + name, null).get();
    }

    @Override
    public EurekaTransportConfig getTransportConfig() {
        return this.transportConfig;
    }
}

