package ONVIF::Device::Types::StreamSetup;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Stream_of :ATTR(:get<Stream>);
my %Transport_of :ATTR(:get<Transport>);

__PACKAGE__->_factory(
    [ qw(        Stream
        Transport

    ) ],
    {
        'Stream' => \%Stream_of,
        'Transport' => \%Transport_of,
    },
    {
        'Stream' => 'ONVIF::Device::Types::StreamType',
        'Transport' => 'ONVIF::Device::Types::Transport',
    },
    {

        'Stream' => 'Stream',
        'Transport' => 'Transport',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::StreamSetup

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
StreamSetup from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Stream


=item * Transport




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::StreamSetup
   Stream => $some_value, # StreamType
   Transport =>  { # ONVIF::Device::Types::Transport
     Protocol => $some_value, # TransportProtocol
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

