package ONVIF::Device::Types::Mpeg4Configuration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %GovLength_of :ATTR(:get<GovLength>);
my %Mpeg4Profile_of :ATTR(:get<Mpeg4Profile>);

__PACKAGE__->_factory(
    [ qw(        GovLength
        Mpeg4Profile

    ) ],
    {
        'GovLength' => \%GovLength_of,
        'Mpeg4Profile' => \%Mpeg4Profile_of,
    },
    {
        'GovLength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Mpeg4Profile' => 'ONVIF::Device::Types::Mpeg4Profile',
    },
    {

        'GovLength' => 'GovLength',
        'Mpeg4Profile' => 'Mpeg4Profile',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::Mpeg4Configuration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Mpeg4Configuration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * GovLength


=item * Mpeg4Profile




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::Mpeg4Configuration
   GovLength =>  $some_value, # int
   Mpeg4Profile => $some_value, # Mpeg4Profile
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

