
package ONVIF::Media::Elements::PTZConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/schema' }

__PACKAGE__->__set_name('PTZConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    ONVIF::Media::Types::PTZConfiguration
);

}

1;


=pod

=head1 NAME

ONVIF::Media::Elements::PTZConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
PTZConfiguration from the namespace http://www.onvif.org/ver10/schema.







=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::PTZConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::PTZConfiguration
   NodeToken => $some_value, # ReferenceToken
   DefaultAbsolutePantTiltPositionSpace =>  $some_value, # anyURI
   DefaultAbsoluteZoomPositionSpace =>  $some_value, # anyURI
   DefaultRelativePanTiltTranslationSpace =>  $some_value, # anyURI
   DefaultRelativeZoomTranslationSpace =>  $some_value, # anyURI
   DefaultContinuousPanTiltVelocitySpace =>  $some_value, # anyURI
   DefaultContinuousZoomVelocitySpace =>  $some_value, # anyURI
   DefaultPTZSpeed =>  { # ONVIF::Media::Types::PTZSpeed
     PanTilt => ,
     Zoom => ,
   },
   DefaultPTZTimeout =>  $some_value, # duration
   PanTiltLimits =>  { # ONVIF::Media::Types::PanTiltLimits
     Range =>  { # ONVIF::Media::Types::Space2DDescription
       URI =>  $some_value, # anyURI
       XRange =>  { # ONVIF::Media::Types::FloatRange
         Min =>  $some_value, # float
         Max =>  $some_value, # float
       },
       YRange =>  { # ONVIF::Media::Types::FloatRange
         Min =>  $some_value, # float
         Max =>  $some_value, # float
       },
     },
   },
   ZoomLimits =>  { # ONVIF::Media::Types::ZoomLimits
     Range =>  { # ONVIF::Media::Types::Space1DDescription
       URI =>  $some_value, # anyURI
       XRange =>  { # ONVIF::Media::Types::FloatRange
         Min =>  $some_value, # float
         Max =>  $some_value, # float
       },
     },
   },
   Extension =>  { # ONVIF::Media::Types::PTZConfigurationExtension
     PTControlDirection =>  { # ONVIF::Media::Types::PTControlDirection
       EFlip =>  { # ONVIF::Media::Types::EFlip
         Mode => $some_value, # EFlipMode
       },
       Reverse =>  { # ONVIF::Media::Types::Reverse
         Mode => $some_value, # ReverseMode
       },
       Extension =>  { # ONVIF::Media::Types::PTControlDirectionExtension
       },
     },
     Extension =>  { # ONVIF::Media::Types::PTZConfigurationExtension2
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

