package ONVIF::PTZ::Types::EndpointReferenceType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.w3.org/2005/08/addressing' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Address_of :ATTR(:get<Address>);
my %ReferenceParameters_of :ATTR(:get<ReferenceParameters>);
my %Metadata_of :ATTR(:get<Metadata>);

__PACKAGE__->_factory(
    [ qw(        Address
        ReferenceParameters
        Metadata

    ) ],
    {
        'Address' => \%Address_of,
        'ReferenceParameters' => \%ReferenceParameters_of,
        'Metadata' => \%Metadata_of,
    },
    {
        'Address' => 'ONVIF::PTZ::Types::AttributedURIType',
        'ReferenceParameters' => 'ONVIF::PTZ::Types::ReferenceParametersType',
        'Metadata' => 'ONVIF::PTZ::Elements::Metadata',

    },
    {

        'Address' => 'Address',
        'ReferenceParameters' => 'ReferenceParameters',
        'Metadata' => '',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

ONVIF::PTZ::Types::EndpointReferenceType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EndpointReferenceType from the namespace http://www.w3.org/2005/08/addressing.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Address


=item * ReferenceParameters


=item * Metadata

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::EndpointReferenceType
   Address =>  { value => $some_value },
   ReferenceParameters =>  { # ONVIF::PTZ::Types::ReferenceParametersType
   },
   Metadata =>  { # ONVIF::PTZ::Types::MetadataType
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

